package gov.va.med.mhv.admin.web.validator;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.ResourceBundle;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.validator.FacesValidator;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

@FacesValidator(value = "accountActivityValidator")
public class AccountActivityValidator implements Validator {

	// private static final Pattern pattern =
	// Pattern.compile("^[A-Za-z][0-9][0-9][0-9][0-9]$");

	@Override
	public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {

		// Activity Validations
		String toDate = null;
		String fromDate = null;

		// Activity Page Validations
		UIInput toDtValue = (UIInput) component.getAttributes().get("toDate");
		UIInput fromDtValue = (UIInput) component.getAttributes().get("fromDate");

		// Activity Validations

		if (toDtValue != null && toDtValue.getValue() != null) {
			Date toDateTemp = (Date) toDtValue.getValue();
			toDate = dateToString(toDateTemp, "yyyyMMdd");
			// toDate = (String) toDtValue.getValue();
		}
		if (fromDtValue != null && fromDtValue.getValue() != null) {
			Date fromDateTemp = (Date) fromDtValue.getValue();
			fromDate = dateToString(fromDateTemp, "yyyyMMdd");
			// fromDate = (String) fromDtValue.getValue();
		}

		// Activity Validations

		Calendar cal = Calendar.getInstance();
		String currentDate = dateToString(cal.getTime(), "yyyyMMdd");
		cal.add(Calendar.YEAR, -3);
		String oldDate = dateToString(cal.getTime(), "yyyyMMdd");

		if (toDate == null) {
			ResourceBundle bundle = ResourceBundle.getBundle("labels.messages",
					FacesContext.getCurrentInstance().getViewRoot().getLocale());
			throw new ValidatorException(
					new FacesMessage(FacesMessage.SEVERITY_ERROR, bundle.getString("toDateRequired"), ""));

		}

		if (fromDate == null) {
			ResourceBundle bundle = ResourceBundle.getBundle("labels.messages",
					FacesContext.getCurrentInstance().getViewRoot().getLocale());
			throw new ValidatorException(
					new FacesMessage(FacesMessage.SEVERITY_ERROR, bundle.getString("fromDateRequired"), ""));

		}

		if (Integer.parseInt(fromDate) < Integer.parseInt(oldDate)
				|| Integer.parseInt(fromDate) > Integer.parseInt(currentDate)
				|| Integer.parseInt(toDate) < Integer.parseInt(oldDate)
				|| Integer.parseInt(toDate) > Integer.parseInt(currentDate)
				|| (Integer.parseInt(fromDate) > Integer.parseInt(toDate))) {

			if (Integer.parseInt(fromDate) > Integer.parseInt(currentDate)
					|| Integer.parseInt(toDate) > Integer.parseInt(currentDate)) {
				ResourceBundle bundle = ResourceBundle.getBundle("labels.messages",
						FacesContext.getCurrentInstance().getViewRoot().getLocale());
				throw new ValidatorException(
						new FacesMessage(FacesMessage.SEVERITY_ERROR, bundle.getString("invalidFutureDate"), ""));
			}

			if (Integer.parseInt(fromDate) > Integer.parseInt(toDate)) {
				ResourceBundle bundle = ResourceBundle.getBundle("labels.messages",
						FacesContext.getCurrentInstance().getViewRoot().getLocale());
				throw new ValidatorException(
						new FacesMessage(FacesMessage.SEVERITY_ERROR, bundle.getString("errorFromGrtSummary"), ""));
			}

			if (Integer.parseInt(fromDate) < Integer.parseInt(oldDate)
					|| Integer.parseInt(toDate) < Integer.parseInt(oldDate)) {
				ResourceBundle bundle = ResourceBundle.getBundle("labels.messages",
						FacesContext.getCurrentInstance().getViewRoot().getLocale());
				throw new ValidatorException(
						new FacesMessage(FacesMessage.SEVERITY_ERROR, bundle.getString("invalidDateRange"), ""));
			}
		}

	}

	private static String dateToString(Date date, String format) {
		String stringDate = "";
		try {
			if (date != null) {
				SimpleDateFormat sdf = new SimpleDateFormat(format);
				stringDate = sdf.format(date);
			}
		} catch (Exception e) {
			throw new RuntimeException("Invalid Date format: ", e);
		}
		return stringDate;
	}

}
